/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.profiling;

import emulator.hardware.debug.AddressStatistics;
import emulator.hardware.debug.CpuProfiler;
import emulator.hardware.debug.profiling.CodeSegment;
import emulator.shell.GUI.debugger.CodePanel;
import emulator.shell.GUI.profiling.ProfilingStatisticsVM;
import emulator.shell.GUI.profiling.ProfilingStatisticsView;
import java.util.Collection;

public class ProfilingStatisticsPresenter {
    private CodePanel codePanel = null;
    private ProfilingStatisticsView view = null;
    private String appName;

    public ProfilingStatisticsPresenter(String appName, CodePanel codePanel) {
        this.appName = appName;
        this.codePanel = codePanel;
    }

    public void toggleView() {
        if (this.view == null) {
            this.view = new ProfilingStatisticsView(this.appName, this);
            this.view.initView(this.createViewModel());
            this.view.restorePosition();
            this.view.setVisible(true);
        } else {
            this.view.toFront();
        }
    }

    private ProfilingStatisticsVM createViewModel() {
        ProfilingStatisticsVM profilingStatisticsVM = new ProfilingStatisticsVM();
        CpuProfiler profiler = this.codePanel.getProfiler();
        long totalTicks = 0L;
        int address = 0;
        while (address < 65535) {
            AddressStatistics statistics = profiler.getStatisticsForAddress(address);
            if (statistics.getCycleCounter() > 0) {
                profilingStatisticsVM.addAddressStatistics(address, statistics.getCycleCounter(), statistics.getExecutionCounter(), this.codePanel.getLabel(address));
                totalTicks += (long)statistics.getCycleCounter();
            }
            profilingStatisticsVM.setTotalTicks(totalTicks);
            ++address;
        }
        Collection<CodeSegment> codeSegments = profiler.getCallGraph().getCodeSegments();
        for (CodeSegment codeSegment : codeSegments) {
            profilingStatisticsVM.prepareCodeSegment(codeSegment, this.codePanel.getLabel(codeSegment.getEnterAddress()));
        }
        for (CodeSegment codeSegment : codeSegments) {
            profilingStatisticsVM.processCodeSegment(codeSegment);
        }
        profilingStatisticsVM.addTopLevelSegments(profiler.getCallGraph().getTopLevelSegments(), this.codePanel);
        profilingStatisticsVM.postProcess();
        return profilingStatisticsVM;
    }

    public void showCode(int address) {
        if (this.codePanel != null) {
            this.codePanel.showCode(address, true);
        }
    }

    public void onCloseView() {
        this.view = null;
    }

    public void closeView() {
        if (this.view != null) {
            this.view.setVisible(false);
            this.view = null;
        }
    }

    public void resetStatisticsAndCloseView() {
        this.codePanel.getProfiler().reset();
        this.closeView();
    }
}

